/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonEmptyFruList;
import com.ibm.hwmca.xfw.service.panel.PBCommonFruListExhausted;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PIAutoFruSelection
implements Effector {
    private static final String TRACE_MASKT = "XRVPAFST";
    private static final String TRACE_MASKF = "XRVPAFSF";
    private static final String TRACE_MASKD = "XRVPAFSD";

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> PIAutoFruSelection.fire");
        try {
            Map userData = context.getUserData();
            List fruList = (List)userData.get("FRU_LIST");
            userData.put("PARTIAL_FRU_GROUP_SELECTED", Boolean.FALSE);
            if (fruList != null) {
                Vector<Fru> selectedFrus = new Vector<Fru>();
                Iterator it = fruList.iterator();
                Integer currentFruBlockId = null;
                Integer selectedFruBlockId = null;
                boolean done = false;
                int firstSelectedFruType = -1;
                while (it.hasNext() && !done) {
                    Fru fru = (Fru)it.next();
                    Map fruProps = fru.getProperties();
                    Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, processing FRU: " + fru);
                    Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, FRU properties: " + fruProps);
                    Boolean exchangedFlag = (Boolean)fruProps.get("EXCHANGED");
                    exchangedFlag = exchangedFlag == null ? Boolean.FALSE : exchangedFlag;
                    Boolean selectedFlag = (Boolean)fruProps.get("SELECTED");
                    selectedFlag = selectedFlag == null ? Boolean.FALSE : selectedFlag;
                    boolean hardwareFruSelected = false;
                    int currentFruType = -1;
                    if (!selectedFlag.equals(Boolean.FALSE) || !exchangedFlag.equals(Boolean.FALSE)) continue;
                    Integer ff = (Integer)fruProps.get("FLAGS");
                    if (firstSelectedFruType == -1) {
                        firstSelectedFruType = ff == null ? 1 : ff;
                        firstSelectedFruType = firstSelectedFruType == 1 ? 1 : 4;
                    }
                    currentFruType = ff == null ? 1 : ff;
                    currentFruType = currentFruType == 1 ? 1 : 4;
                    currentFruBlockId = (Integer)fruProps.get("EXCHANGE_BLOCK");
                    if (selectedFruBlockId == null) {
                        selectedFruBlockId = currentFruBlockId;
                        fruProps.put("SELECTED", Boolean.TRUE);
                    }
                    if (selectedFruBlockId == null) {
                        done = true;
                        selectedFrus.add(fru);
                        continue;
                    }
                    if (!selectedFruBlockId.equals(currentFruBlockId)) continue;
                    Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, multiple FRUs found in exchange block: " + currentFruBlockId);
                    if (currentFruType != firstSelectedFruType) {
                        Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, splitting exchange block up into subblocks because of different FRU types in the same exchange block");
                        userData.put("PARTIAL_FRU_GROUP_SELECTED", Boolean.TRUE);
                        continue;
                    }
                    fruProps.put("SELECTED", Boolean.TRUE);
                    selectedFrus.add(fru);
                }
                userData.put("SELECTED_FRUS", selectedFrus);
                if (selectedFrus.size() == 0) {
                    String serviceActionType = (String)userData.get("rvType");
                    if (serviceActionType.equals(ServiceActionType.REPAIR_PROBLEM.getValue())) {
                        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                        CommonDataBean bean = new PBCommonFruListExhausted();
                        bean = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                        context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.FRU_LIST_EXHAUSTED);
                        Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, all frus exchanged? ...setting type 2");
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.EXIT);
                    } else {
                        context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.PROBLEM_FIXED);
                    }
                } else {
                    context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.SELECTED);
                }
            } else {
                Trace.trace(TRACE_MASKF, "PIAutoFruSelection.fire, NO frus in the callout list?  Contact next level of support.");
                GenericGui guiHandle = (GenericGui)context.getUserData().get("DISPLAY_HANDLE");
                CommonDataBean bean = new PBCommonEmptyFruList();
                bean = (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.EXIT);
            }
            Trace.trace(TRACE_MASKT, "<- PIAutoFruSelection.fire");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIAutoFruSelection.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof EffectorException)) {
                throw new EffectorException(e);
            }
            throw (EffectorException)e;
        }
    }

    private void makeType2(Context context) throws EffectorException {
        try {
            Map userData = context.getUserData();
            ProblemManager pm = ProblemManager.getProblemManager();
            CommonProblem p = (CommonProblem)userData.get("SERVICEABLE_EVENT");
            p.setProblemType("2");
            pm.changed(p);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIAutoFruSelection.makeType2, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
    }
}

